//**************************************************
//	Digit Widgets Interpolate Module
// 	2,3,4 and Traveling Point Interpolation Script
//	Made to be called from Hyperlinked Digit_Widgets Script
//
// Version 3.0 - 09/12/01 - Added Animation Script to Widgets
//	Version 3.1 - 09/15/01 - Updated with Advanced and Standard Animation Scripts
//**************************************************
<zscriptinsert,"Digit_Widgets_Common_Std.txt">
[PD]
[FontSetColor,255,200,0]Curve Object Interpolates[FontSetColor,160,160,160]
[PD]
//Create a Curve using 2 marks, straight,Spline, or Bezel
[VarDef,ccntr,0]
[VarDef,cptr,1]
[VarDef,crecurse,0]
[VarDef,Itmp,0]
[VarDef,ICTime,.1]
[VarDef,cmulti1,1]
[VarDef,cmulti2,1]
[VarDef,resultx,0]
[VarDef,resulty,0]
[VarDef,resultz,0]
[VarDef,resultxs,0]
[VarDef,resultys,0]
[VarDef,resultzs,0]
[VarDef,resultxr,0]
[VarDef,resultyr,0]
[VarDef,resultzr,0]
[VarDef,resultmx,0]
[VarDef,resultmy,0]
[VarDef,resultmz,0]
[VarDef,resultmxs,0]
[VarDef,resultmys,0]
[VarDef,resultmzs,0]
[VarDef,resultmxr,0]
[VarDef,resultmyr,0]
[VarDef,resultmzr,0]
[VarDef,Ipoints,10];
[iSlider,"Number of Points ",10,1,0,1000,"Number of Points in Interpolation", 
	[varSet,Ipoints,zscript:NumberofPoints]
	[VarSet,ICtime,1.0/Ipoints]
	
,0,[TextCalcWidth,Distance14537890123]]
[iSlider,"StartMark ",1,1,1,10,"Starting Mark",[varSet,sel1,zscript:StartMark],0,[TextCalcWidth,Distance1453]]
[iSlider,"EndMark ",2,1,1,10,"Ending Mark",[varSet,sel2,zscript:EndMark],0,[TextCalcWidth,Distance1453]]
[PD]
[iSwitch,"2Point",1,"Straight Line Interpolate",
	[if,zscript:2Point,
		[ISetStatus,zscript:LoadPoint_1,0]
		[ISetStatus,zscript:LoadPoint_2,0]
		[IDisable,zscript:Move_1]
		[IDisable,zscript:Move_2]
	]
	[if,zscript:3Point,
		[IToggle,zscript:3Point]
	]
	[if,zscript:4Point,
		[IToggle,zscript:4Point]
	]
	[if,zscript:1TO2,
		[IToggle,zscript:1TO2]
	]
] 

[iSwitch,"3Point",0,"1 Point Spline Interpolate",
	[if,zscript:3Point,
		[ISetStatus,zscript:LoadPoint_1,1]
		[ISetStatus,zscript:LoadPoint_2,0]
		[IEnable,zscript:Move_1]
		[IDisable,zscript:Move_2]
	]
	[if,zscript:2Point,
		[IToggle,zscript:2Point]
	]
	[if,zscript:4Point,
		[IToggle,zscript:4Point]
	]
	[if,zscript:1TO2,
		[IToggle,zscript:1TO2]
	]
]

[iSwitch,"4Point",0,"2 Point Bezier Interpolate",
	[if,zscript:4Point,
		[ISetStatus,zscript:LoadPoint_1,1]
		[ISetStatus,zscript:LoadPoint_2,1]
		[IEnable,zscript:Move_1]
		[IEnable,zscript:Move_2]
	]
	[if,zscript:2Point,
		[IToggle,zscript:2Point]
	]
	[if,zscript:3Point,
		[IToggle,zscript:3Point]
	]
	[if,zscript:1TO2,
		[IToggle,zscript:1TO2]
	]
]

[iSwitch,"1TO2",0,"Make Spline point travel from LoadPt 1 to Loadpt 2",
	[if,zscript:1TO2,
		[ISetStatus,zscript:LoadPoint_1,1]
		[ISetStatus,zscript:LoadPoint_2,1]
		[IEnable,zscript:Move_1]
		[IEnable,zscript:Move_2]
	]
	[if,zscript:2Point,
		[IToggle,zscript:2Point]
	]
	[if,zscript:3Point,
		[IToggle,zscript:3Point]
	]
	[if,zscript:4Point,
		[IToggle,zscript:4Point]
	]
]
[PD]
[iSwitch,"C-Sizeit",0,"Size to Position"] 
[iSwitch,"C-Snapshot",0,"Perform Snapshot"] 
[iSwitch,"C-Rotateit",0,"Interpolate Rotation"] 
[PD]
[iButton," LoadPoint_1 ","Load Current Object Position to use as Spline Point in Curve",
[TransformGet,SpointX(0),SpointY(0),SpointZ(0),SpointXS(0),SpointYS(0),SpointZS(0),SpointXR(0),SpointYR(0),SpointZR(0)]
[VarSet,KpointX(0),SpointX(0)]
[VarSet,KpointY(0),SpointY(0)]
[VarSet,KpointZ(0),SpointZ(0)]
[VarSet,KpointXS(0),SpointXS(0)]
[VarSet,KpointYS(0),SpointYS(0)]
[VarSet,KpointZS(0),SpointZS(0)]
[VarSet,KpointXR(0),SpointXR(0)]
[VarSet,KpointYR(0),SpointYR(0)]
[VarSet,KpointZR(0),SpointZR(0)]
,1
]//End Load Point 1

[iButton," Move_1 ","Load Current Object Position to LoadPoint_1",
	[TransformSet,KpointX(0),KpointY(0),KpointZ(0),KpointXS(0),KpointYS(0),KpointZS(0),KpointXR(0),KpointYR(0),KpointZR(0)],1
]

[iButton," LoadPoint_2 ","Load Current Object Position to use as Spline Point in Curve",
[TransformGet,SpointX(1),SpointY(1),SpointZ(1),SpointXS(1),SpointYS(1),SpointZS(1),SpointXR(1),SpointYR(1),SpointZR(1)]
[VarSet,KpointX(1),SpointX(1)]
[VarSet,KpointY(1),SpointY(1)]
[VarSet,KpointZ(1),SpointZ(1)]
[VarSet,KpointXS(1),SpointXS(1)]
[VarSet,KpointYS(1),SpointYS(1)]
[VarSet,KpointZS(1),SpointZS(1)]
[VarSet,KpointXR(1),SpointXR(1)]
[VarSet,KpointYR(1),SpointYR(1)]
[VarSet,KpointZR(1),SpointZR(1)]
,1
]//End Load Point 2

[iButton," Move_2 ","Load Current Object Position to LoadPoint_2",
	[TransformSet,KpointX(1),KpointY(1),KpointZ(1),KpointXS(1),KpointYS(1),KpointZS(1),KpointXR(1),KpointYR(1),KpointZR(1)],1
]

[iButton,"Run Interpolation ","Execute Selected Interpolation",
	//first thing move to first mark and snapshot if required
	[TransformSet,MarkX(sel1),MarkY(sel1),MarkZ(sel1),MarkXS(sel1),MarkYS(sel1),MarkZS(sel1),MarkXR(sel1),MarkYR(sel1),MarkZR(sel1)]
	//go ahead and get all of the current data do only once for recursive
	[TransformGet,IcurrX,IcurrY,IcurrZ,IcurrXS,IcurrYS,IcurrZS,currXR,currYR,currZR]
	// see if any movement of spline point has occurred

	[if,cmulti1<>0,
		[if,zscript:3point,

			//rotate xyAxis
			[VarSet,tmp,dangle*2]
			[VarSet,tmp,180-tmp]
			[VarSet,dangle1,dangle+tmp]
			[if,dangle1<0,
				[VarSet,dangle1,360-ABS(dangle1)]]

			//calc XY angle
			[VarSet,tmp,COS(dangle1)]
			[VarSet,ypt,cmulti1*tmp]
			[VarSet,tmp,SIN(dangle1)]
			[VarSet,xpt,cmulti1*tmp]
		
			[VarSet,SpointX(0),KpointX(0)+xpt]
			[VarSet,SpointY(0),KpointY(0)+ypt]
		]
		[if,zscript:4point,
//Loadpoint1 move
			//rotate xyAxis
			[VarSet,tmp,dangle*2]
			[VarSet,tmp,180-tmp]
			[VarSet,dangle1,dangle+tmp]
			[if,dangle1<0,
				[VarSet,dangle1,360-ABS(dangle1)]]

			//calc XY angle
			[VarSet,tmp,COS(dangle1)]
			[VarSet,ypt,cmulti1*tmp]
			[VarSet,tmp,SIN(dangle1)]
			[VarSet,xpt,cmulti1*tmp]
		
			[VarSet,SpointX(0),KpointX(0)+xpt]
			[VarSet,SpointY(0),KpointY(0)+ypt]


//loadpoint2 move
			//rotate xyAxis
			[VarSet,tmp,zdangle*2]
			[VarSet,tmp,180-tmp]
			[VarSet,dangle1,zdangle+tmp]
			[if,dangle1<0,
				[VarSet,dangle1,360-ABS(dangle1)]]

			//calc XY angle
			[VarSet,tmp,COS(dangle1)]
			[VarSet,ypt,cmulti2*tmp]
			[VarSet,tmp,SIN(dangle1)]
			[VarSet,xpt,cmulti2*tmp]
		
			[VarSet,SpointX(1),KpointX(1)+xpt]
			[VarSet,SpointY(1),KpointY(1)+ypt]

		]
		[if,zscript:1TO2,
//Loadpoint1 move
			//rotate xyAxis
			[VarSet,tmp,dangle*2]
			[VarSet,tmp,180-tmp]
			[VarSet,dangle1,dangle+tmp]
			[if,dangle1<0,
				[VarSet,dangle1,360-ABS(dangle1)]]

			//calc XY angle
			[VarSet,tmp,COS(dangle1)]
			[VarSet,ypt,cmulti1*tmp]
			[VarSet,tmp,SIN(dangle1)]
			[VarSet,xpt,cmulti1*tmp]
		
			[VarSet,SpointX(0),KpointX(0)+xpt]
			[VarSet,SpointY(0),KpointY(0)+ypt]


//loadpoint2 move
			//rotate xyAxis
			[VarSet,tmp,zdangle*2]
			[VarSet,tmp,180-tmp]
			[VarSet,dangle1,zdangle+tmp]
			[if,dangle1<0,
				[VarSet,dangle1,360-ABS(dangle1)]]

			//calc XY angle
			[VarSet,tmp,COS(dangle1)]
			[VarSet,ypt,cmulti2*tmp]
			[VarSet,tmp,SIN(dangle1)]
			[VarSet,xpt,cmulti2*tmp]
		
			[VarSet,SpointX(1),KpointX(1)+xpt]
			[VarSet,SpointY(1),KpointY(1)+ypt]

		]
	]
	[if,[iGet,zscript:C-Snapshot],
		[IPress,Transform:Snapshot]
	]//endif

	//how many time to recurse
	[VarSet,ccntr,1.0/ICTime]
	[VarSet,cptr,1]
	[VarInc,ccntr]
	[Loop,ccntr,
		//interpolate Straight, Spline, or Bezel line
		[VarSet,crecurse,ICTime*cptr]
		[if,zscript:2Point,
			[VarSet,resultx,[Interpolate,crecurse,MarkX(sel1),MarkX(sel2)]]
			[VarSet,resulty,[Interpolate,crecurse,MarkY(sel1),MarkY(sel2)]]
			[VarSet,resultz,[Interpolate,crecurse,MarkZ(sel1),MarkZ(sel2)]]
		]
		[if,zscript:3Point,
			[VarSet,resultx,[Interpolate,crecurse,MarkX(sel1),SpointX(0),MarkX(sel2)]]
			[VarSet,resulty,[Interpolate,crecurse,MarkY(sel1),SpointY(0),MarkY(sel2)]]
			[VarSet,resultz,[Interpolate,crecurse,MarkZ(sel1),SpointZ(0),MarkZ(sel2)]]
		]
		[if,zscript:4Point,
			[VarSet,resultx,[Interpolate,crecurse,SpointX(0),MarkX(sel1),MarkX(sel2),SpointX(1)]]
			[VarSet,resulty,[Interpolate,crecurse,SpointY(0),MarkY(sel1),MarkY(sel2),SpointY(1)]]
			[VarSet,resultz,[Interpolate,crecurse,SpointZ(0),MarkZ(sel1),MarkZ(sel2),SpointZ(1)]]
		]

		[if,zscript:1TO2,
			[VarSet,resultmx,[Interpolate,crecurse,SpointX(0),SpointX(1)]]
			[VarSet,resultmy,[Interpolate,crecurse,SpointY(0),SpointY(1)]]
			[VarSet,resultmz,[Interpolate,crecurse,SpointZ(0),SpointZ(1)]]

			[VarSet,resultx,[Interpolate,crecurse,MarkX(sel1),resultmx,MarkX(sel2)]]
			[VarSet,resulty,[Interpolate,crecurse,MarkY(sel1),resultmy,MarkY(sel2)]]
			[VarSet,resultz,[Interpolate,crecurse,MarkZ(sel1),resultmz,MarkZ(sel2)]]
		]
		//Size Object
		[if,[iGet,zscript:C-Sizeit],
			[if,zscript:2Point,
				[VarSet,resultxs,[Interpolate,crecurse,MarkXS(sel1),MarkXS(sel2)]]
				[VarSet,resultys,[Interpolate,crecurse,MarkYS(sel1),MarkYS(sel2)]]
				[VarSet,resultzs,[Interpolate,crecurse,MarkZS(sel1),MarkZS(sel2)]]
			]
			[if,zscript:3Point,
				[VarSet,resultxs,[Interpolate,crecurse,MarkXS(sel1),SpointXS(0),MarkXS(sel2)]]
				[VarSet,resultys,[Interpolate,crecurse,MarkYS(sel1),SpointYS(0),MarkYS(sel2)]]
				[VarSet,resultzs,[Interpolate,crecurse,MarkZS(sel1),SpointZS(0),MarkZS(sel2)]]
			]
			[if,zscript:4Point,
				[VarSet,resultxs,[Interpolate,crecurse,SpointXS(0),MarkXS(sel1),MarkXS(sel2),SpointXS(1)]]
				[VarSet,resultys,[Interpolate,crecurse,SpointYS(0),MarkYS(sel1),MarkYS(sel2),SpointYS(1)]]
				[VarSet,resultzs,[Interpolate,crecurse,SpointZS(0),MarkZS(sel1),MarkZS(sel2),SpointZS(1)]]
			]

			[if,zscript:1TO2,
				[VarSet,resultmxs,[Interpolate,crecurse,SpointXS(0),SpointXS(1)]]
				[VarSet,resultmys,[Interpolate,crecurse,SpointYS(0),SpointYS(1)]]
				[VarSet,resultmzs,[Interpolate,crecurse,SpointZS(0),SpointZS(1)]]
				
				[VarSet,resultxs,[Interpolate,crecurse,MarkXS(sel1),resultmxs,MarkXS(sel2)]]
				[VarSet,resultys,[Interpolate,crecurse,MarkYS(sel1),resultmys,MarkYS(sel2)]]
				[VarSet,resultzs,[Interpolate,crecurse,MarkZS(sel1),resultmzs,MarkZS(sel2)]]
			]
		,//else
			[VarSet,resultxs,MarkXS(sel1)]
			[VarSet,resultys,MarkYS(sel1)]
			[VarSet,resultzs,MarkZS(sel1)]
		]//Endif

		//Rotate Object
		[if,[iGet,zscript:C-Rotateit],
			[if,zscript:2Point,
				[VarSet,resultxr,[Interpolate,crecurse,MarkXR(sel1),MarkXR(sel2)]]
				[VarSet,resultyr,[Interpolate,crecurse,MarkYR(sel1),MarkYR(sel2)]]
				[VarSet,resultzr,[Interpolate,crecurse,MarkZR(sel1),MarkZR(sel2)]]
			]
			[if,zscript:3Point,
				[VarSet,resultxr,[Interpolate,crecurse,MarkXR(sel1),SpointXR(0),MarkXR(sel2)]]
				[VarSet,resultyr,[Interpolate,crecurse,MarkYR(sel1),SpointYR(0),MarkYR(sel2)]]
				[VarSet,resultzr,[Interpolate,crecurse,MarkZR(sel1),SpointZR(0),MarkZR(sel2)]]
			]
			[if,zscript:4Point,
				[VarSet,resultxr,[Interpolate,crecurse,SpointXR(0),MarkXR(sel1),MarkXR(sel2),SpointXR(1)]]
				[VarSet,resultyr,[Interpolate,crecurse,SpointYR(0),MarkYR(sel1),MarkYR(sel2),SpointYR(1)]]
				[VarSet,resultzr,[Interpolate,crecurse,SpointZR(0),MarkZR(sel1),MarkZR(sel2),SpointZR(1)]]
			]

			[if,zscript:1TO2,
				[VarSet,resultmxr,[Interpolate,crecurse,SpointXR(0),SpointXR(1)]]
				[VarSet,resultmyr,[Interpolate,crecurse,SpointYR(0),SpointYR(1)]]
				[VarSet,resultmzr,[Interpolate,crecurse,SpointZR(0),SpointZR(1)]]

				[VarSet,resultxr,[Interpolate,crecurse,MarkXR(sel1),resultmxr,MarkXR(sel2)]]
				[VarSet,resultyr,[Interpolate,crecurse,MarkYR(sel1),resultmyr,MarkYR(sel2)]]
				[VarSet,resultzr,[Interpolate,crecurse,MarkZR(sel1),resultmzr,MarkZR(sel2)]]
			]
		,//else
			[VarSet,resultxr,MarkXR(sel1)]
			[VarSet,resultyr,MarkYR(sel1)]
			[VarSet,resultzr,MarkZR(sel1)]
		]//Endif
		


		[TransformSet,resultx,resulty,resultz,resultxs,resultys,resultzs,resultxr,resultyr,resultzr]

		[if,[iGet,zscript:C-Snapshot],
			[IPress,Transform:Snapshot]
		]//endif
		[VarInc,cptr]	//add one to ptr
	]//end loop
]//End Curveit_3
[PD]
[pd][penMove,0,8]
<zscriptinsert,"Widgets_Index_Include_Std.txt">
[pd][penMove,0,8]
\C00e0e0About This ZScript:
\Cc0c0c0This script will allow you to procreate a number of objects along a line defined by two Position Markers. First you select the \Cffa000Number of Points\Cc0c0c0 and then select the \Cffa000StartMark\Cc0c0c0 and \Cffa000EndMark\Cc0c0c0 that you want your object line to span. There are four types of interpolation to choose from:
[PD]
 \Cffa0002 Point\Cc0c0c0 generates a straight line from the StartMark to the EndMark. 
[PD]
When you select \Cffa0003 Point\Cc0c0c0 this straight line becomes effected by a third point or spline point that you define by manuvering your object to a position on the canvas XYZ and pressing \Cffa000LoadPoint_1\Cc0c0c0. This position may be recalled at any time by pressing \Cffa000Move_1\Cc0c0c0. 
[PD]
When you select \Cffa0004 Point\Cc0c0c0 this straight line becomes effected by a third and 4th point or spline point that you define by manuvering your object to a position on the canvas XYZ and pressing \Cffa000LoadPoint_1\Cc0c0c0. This position may be recalled at any time by pressing \Cffa000Move_1\Cc0c0c0. Add the 4 Point by pressing \Cffa000LoadPoint_2\Cc0c0c0. This position may be recalled at any time by pressing \Cffa000Move_2\Cc0c0c0. This curve is like a Bezier Curve 
[PD]
When you select \Cffa0004 Point\Cc0c0c0 this straight line becomes effected by a third and 4th point or spline point that you define by manuvering your object to a position on the canvas XYZ and pressing \Cffa000LoadPoint_1\Cc0c0c0. This position may be recalled at any time by pressing \Cffa000Move_1\Cc0c0c0 and \Cffa000LoadPoint_2\Cc0c0c0. This position may be recalled at any time by pressing \Cffa000Move_2\Cc0c0c0. This curve is different than the \Cffa0004 Point\Cc0c0c0 curve because the Spline point will be moving from  \Cffa000LoadPoint_1\Cc0c0c0 to \Cffa000LoadPoint_2\Cc0c0c0 in time thus causing the effect on the main interpolation to change during the execution of the script. This feature is the coolest and can provide a more pronounced S Curve or other shapes than the \Cffa0003 Point\Cc0c0c0 mode.
[PD]
\Cffa000C-Sizeit\Cc0c0c0 when enabled will interpolate the Scale of your object as it moves from the StartMark to the EndMak. Otherwise the size of the object will not change over the course of the interpolation
\Cffa000C-SnapShot\Cc0c0c0 when enabled will snapshot each interpolation step to the canvas. Unselect this when you just want to run the interpolation and get an idea of the result.
\Cffa000C-Rotateit\Cc0c0c0 when enabled will interpolate the Rotation of your object as it moves from the StartMark to the EndMark. Otherwise the Rotation of the object will not change over the course of the interpolation.
[PD]
[iButton,"Example ","Interpolation Widget Example",
	[if,[Ireset],
	[IcolorSet,239,234,30]
	[note,"I will select a Cube, any object can be used however",zscript:example,0]
	[ISet,Tool:ItemInfo,9]
	[note,"Drag it onto Canvas",zscript:example,0]
	[CanvasClick,DocMidX,DocMidY,DocMidX+20,DocMidY+20]
	[IPress,Transform:Move]
	[TransformSet,DocMidX,50,0,20,20,20,0,0,-180]
	[note,"Notice that I am holding the object now in a Transform Move, Scale, or Rotation mode and that the Gyro is visible. Next I will use the Position Marker Widget feature and save its Position as Marker 1",zscript:example,0]
	[ISet,zscript:SelectMark,1]
	[Ipress,zscript:Save]
	[IPress,Transform:Snapshot]
	[note,"This will be the start of the Interpolation Line. Next I will move the object to a Position that I would like it to end",zscript:example,0]
	[TransformSet,DocMidX,300,-300,50,50,50,45,0,180]
	[note,"Notice I have Rotated and resized. I will save this in Position Marker #2",zscript:example,0]
	[ISet,zscript:SelectMark,2]
	[Ipress,zscript:Save]
	[IPress,Transform:Snapshot]
	[note,"To make a simple straight line with this object I will make sure that 2Point is selected. Also I will set C-Sizeit so it will grow, C-Rotateit so it will rotate as it moves from Marker 1 to Marker 2",zscript:example,0]
	[if,[IGet,zscript:2Point],
	,
		[IPress,zscript:2_Point]
	]
	[if,[IGet,zscript:C-Sizeit],
	,
		[IPress,zscript:C-Sizeit]
	]
	[if,[IGet,zscript:C-Rotateit],
	,
		[IPress,zscript:C-Rotateit]
	]
	[if,[IGet,zscript:C-Snapshot],
	,
		[IPress,zscript:C-Snapshot]
	]
	[note,"I could also change the number of points between the start and end but I will leave it for now at the default number of 10. Next I press the Run Interpolation button",zscript:example,0]
	[IPress,zscript:RunInterpolation]
	[Note,"I will give you now a example of a 3Point Interpolation, which uses a 3rd point to affect the line. I will select 3Point",zscript:example,0]
	[if,[IGet,zscript:3Point],
	,
		[IPress,zscript:3Point]
	]
	[note,"Notice that the LoadPoint_1 and Move_1 button becomes enabled. I will create the spline point by moving the object to a position on the canvas, rotating, sizing and changing the Z axis position",zscript:example,0]
	[TransformSet,50,DocMidY,200,10,10,10,45,0,0]
	[Note,"I then press the LoadPoint_1 button to save this position. I can return the object to this point anytime by pressing the Move_1 button",zscript:example,0]
	[Ipress,zscript:LoadPoint_1]
	[note,"now lets run the Interpolation again",zscript:example,0]
	[IPress,zscript:RunInterpolation]
	[note,"The 4Point and 1to2 functions are similiar except you would move the object to define the LoadPoint_2 position. the 1to2 point curve is cool because the spline point will move in time from those 2 positions creating some interesting curves.",zscript:example,0]
,//else
	[Note,"Aborting! Maybe another day eh?",,3]
]
]
[PD]
[PD]
[fontSetSizeSmall]\C00e0e0Standard Digit Widget Interpolate Revision 1.0, created by Digits\Cc0c0c0
